define(['bower_components/angular/angular', 'app'], function(angular, app) {
	"use strict";

	app.service('GoalsRemindersService', function(GoalsService, MyRemindersService, $q, $filter, $http, formatter, CollectionCRUDService, PatientPreferenceService) {
		var GoalsRemindersService = {};

		var remindersService = MyRemindersService.instance('goals-reminders');
		var goalsService = GoalsService.instance('goals');

		GoalsRemindersService.getById = function(id) {

			var defer = $q.defer();
			var goal = goalsService.localGetById(id);

			if (goal) {
				var reminder = {};
				remindersService.fetch().then(function() {
					reminder = $filter('filter')(remindersService.dataPointers.list, {healthTrackerId: id}, true);
					reminder = reminder[0] || remindersService.createEmpty();
					if (reminder.alert) {
						delete reminder.alert;
					}
					reminder.eventDate = reminder.eventDate ? formatter.getFormattedFrontendDate(reminder.eventDate) : "";
					reminder.notificationStatus = reminder.enabledFlag ? "On" : "Off";
					reminder.times = formatter.dotifyArrayOfPrimatives(reminder.times);
					if (reminder.notificationTypes) {
						var notificationTypes = ["In-App", "Email"];
						for (var i = 0; i < notificationTypes.length; i++) {
							if (reminder.notificationTypes.indexOf(notificationTypes[i]) === -1) {
								notificationTypes[i] = false;
							}
						}

						reminder.notificationTypes = notificationTypes
					} else {
						reminder.notificationTypes = [];
					}
					defer.resolve(angular.copy({reminder : reminder, goal : goal}));
				});
			}
			else {
				defer.reject();
			}

			return defer.promise;
		};

		GoalsRemindersService.createEmpty = function() {
			return {
				reminder: createEmptyReminder(),
				goal: goalsService.createEmpty()
			};
		};

		var createEmptyReminder = function() {
			var emptyReminder = remindersService.createEmpty();
			emptyReminder.notificationTypes = [];
			emptyReminder.eventDate = null;
			emptyReminder.type = null;
			if (emptyReminder.alert) {
				delete emptyReminder.alert;
			}
			return emptyReminder;
		};

		var createReminderAuxData = function(goal) {
			var preferencesData = PatientPreferenceService.dataPointers.notificationPreference;

			var addressee = preferencesData.firstName + " " + preferencesData.lastName,
				subject = "Your " + goal.identifier[0].value + " goal is due on " + goal.endDate + ".",
				appName = "VA FitHeart",
				appLink = window.location.host + window.location.pathname,
				linkElement = "<a href='" + appLink + "'>" + appName + "</a>",
				emailSignature = appName + "My Goals";

			var body = "<br>" + subject + "<br/>" +
				"This reminder is provided to help you stay focused, track progress, and reach the goal.<br/><br/>";
			if (goal.extension) {
				body += "You indicated your reward for reaching this goal is:<br/>" + goal.identifier[0].valueString + "<br/><br/>";
			}

			var updateMsg = "Update your progress on this goal in the " + linkElement + 
				"<br/>To stop future reminders about this goal, edit this Goal&#39;s notification settings inside the Goal section of the My Story feature within the  " + linkElement;

			var fullMessageBody = addressee + "<br/><br/>" + subject + body + updateMsg + "<br/><br/>" + emailSignature; 

			return [
				{ key: "endDate", value: goal.endDate },
				{ key: "emailSubject", value: subject },
				{ key: "emailBody", value: body },
				{ key: "emailUpdateMessage", value: updateMsg },
				{ key: "messageBody", value: fullMessageBody },
				{ key: "emailSignature", value: "VA FitHeart - Goals Service" },
				{ key: "source", value: "FIT_HEART" },
				{ key: "appUri", value: "fit-heart" },
				{ key: "appName", value: appName }
			];
		};

		var updateLocalList = function(content) {
			goalsService.refresh(content);
		};

		var deleteItemInList = function(content) {
			goalsService.deleteFromList(content);
		};

		GoalsRemindersService.save = function(item) {
			var that = this;
			var defer = $q.defer();
			var reminder = angular.copy(item.reminder);
			delete item.reminder;
			goalsService.save(item.goal).then(function(goal) {
				if (goal.resourceType === "OperationOutcome") {
					var identifier = goal.issue[0].diagnostics.split("/");
					item.goal.id = identifier[1];
				} else if (goal.resourceType === "Goal" && goal.id) {
					item.goal.id = goal.id;
					item.goal.resourceType = goal.resourceType;
				}

				reminder.healthTrackerId = item.goal.id;
				reminder.title = item.goal.identifier[0].value;
				reminder.times = [{
					value: "6:00 AM"
				}];
				reminder.enabledFlag = reminder.notificationStatus === "On";
				reminder.eventDate = item.goal.endDate;
				if (item.goal.extension) {
					reminder.notes = item.goal.extension[0].valueString;
				} else {
					reminder.notes = " ";
				}

				reminder.auxData = createReminderAuxData(item.goal);
				reminder.subject = reminder.auxData[1].value;
				reminder.messageBody =  reminder.auxData[4].value;

				remindersService.save(reminder).then(function(reminder) {
					item.reminder = reminder;
					defer.resolve({
						goal: goal,
						reminder: reminder
					});
					updateLocalList(item.goal);
				}, function(error) {
					defer.reject(error);
				});
			}, function(error) {
				defer.reject(error);
			});

			return defer.promise;
		};

		GoalsRemindersService.delete = function(item) {
			var deleteServiceCalls = item.reminder.id ? {
				reminder: remindersService.delete(item.reminder),
				goal: goalsService.delete(item.goal)
			} : {
				goal: goalsService.delete(item.goal)
			};
			deleteItemInList(item.goal);
			return $q.all(deleteServiceCalls);
		};

		return GoalsRemindersService;
	});
});
